//
// 2002 by Ted T. Yuan.   
//

#include <stdio.h>
#include <string.h>
#include <iostream>
#ifdef _DEBUG
#pragma warning (disable: 4786 4788) 
#endif
#include <string>
#include <vector>

#include <NetworkService.h>


struct HttpHello : SPACE_YIN::NetworkService 
{
	const static char * hello;

	HttpHello(std::string serviceId, 
		int lengthWaitList, int numThreads, unsigned short sourcePort)
		: SPACE_YIN::NetworkService(
		serviceId, lengthWaitList, numThreads, sourcePort) {}

	void ServiceHandler(int socket)
	{
		char buffer[1024];
		int count;
		// we are simple minded...
		if ( (count = recv(socket, buffer, 1024, 0)) > 0)
		{
			if(count < 1024) buffer[count] = 0;
			std::cout << buffer << std::endl;
		}

		static volatile int nVisitors = 0;
		sprintf(buffer, "%s, you are visitor#%d", hello, ++nVisitors);
		send(socket, buffer, strlen(buffer), 0);
		shutdown(socket, 1); //1 = SHUT_WR 
		CloseConnection(socket);
	}
};

const char *HttpHello::hello = 
	"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: close\r\n\r\nHello World";

////////////////////////////////////////////////////
// launch a web server

void main()
{
	initializeWinsock();

	// use a browser to test the server, i.e., http://localhost:1234
	HttpHello hh("Hello Web", 
		10,  // server backlog
		10,  // number of worker threads
		1234 // service port number
		);

	boost::thread thrd(hh);
	thrd.join();

	closeWinsock();
} 
