#ifndef _SOCKET_UTILS_H
#define _SOCKET_UTILS_H

//
// Copyright (c) 2002 by Ted T. Yuan.
//
// Permission is granted to use this code without restriction as long as this copyright notice appears in all source files.
//
#if defined(WIN32)
#include <windows.h>
#else
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <resolv.h>
#include <netdb.h>
#endif

/////////////////////////////////////
// Win32 specific
#if defined(WIN32)
inline void initializeWinsock()
{
	// must init the winsock first
	WORD wVersionRequested;
	WSADATA wsaData;

	wVersionRequested = MAKEWORD(2,2);
	if(0 != WSAStartup(wVersionRequested, &wsaData))
	{
		perror("Winsock initialization failed");
		exit(1);
	}
}

inline void closeWinsock()
{
	WSACleanup();
}
#else
inline void initializeWinsock() {}
inline void closeWinsock() {}
#endif


inline int createServerSocket(short sourcePort, int backlog)
{
	int 	 sd;
	struct   sockaddr_in sin;
 
	// get an internet domain socket 
	if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("ssocket");
		return -1;
	}

	// complete the socket structure 
	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons(sourcePort);

	// bind the socket to the port number 
	if (bind(sd, (struct sockaddr *) &sin, sizeof(sin)) == -1) {
		perror("bind");
		return -1;
	}

	// show that we are willing to listen 
	if (listen(sd, backlog) == -1) {
		perror("listen");
		return -1;
	}

	return sd;
}

inline int acceptClientSocket(int server, struct sockaddr_in& pin)
{
	int client;
#if defined(WIN32)
	int 	 addrlen = sizeof(struct sockaddr_in);
#else
	size_t 	 addrlen = sizeof(struct sockaddr_in);
#endif

	if ((client = accept(server, (struct sockaddr *)  &pin, &addrlen)) == -1) {
		perror("accept");
#if defined(WIN32)
		//wprintf (L"Socket accept, error %d\n", WSAGetLastError ());
#endif
	}
	return client;
}

inline void CloseConnection(int server) // socket id
{
#if defined(WIN32)
	closesocket(server);
#else
	close(server); 
#endif
}

#endif
